#if !defined(AFX_graph_tga_H__3A88D5E6_D046_11D2_BDFF_AB9A94C6D301__INCLUDED_)
#define AFX_graph_tga_H__3A88D5E6_D046_11D2_BDFF_AB9A94C6D301__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "math.h"
#include "error.h"
#include "stdlib.h"
#include "stdio.h"
#include "io.h"
#include "fcntl.h"
#include "sys/types.h"
#include "sys/stat.h"

class graph_tga  
{
public:
	void build_graph (int in_size_x, int in_size_y);
	void write_graph (char* pathstr);
	void draw_circle_filled_abs(int x_pos, int y_pos, int radius, int color_r, int color_g, int color_b);
	void draw_circle_filled_rel(double x_pos, double y_pos, int radius, int color_r, int color_g, int color_b);
	void draw_pixel_abs (int x_pos, int y_pos, int color_r, int color_g, int color_b);
	void draw_pixel_rel (double x_pos, double y_pos, int color_r, int color_g, int color_b);
	void draw_line_abs(int start_x, int start_y, int end_x, int end_y, int color_r, int color_g, int color_b);
	void draw_line_rel(double start_x, double start_y, double end_x, double end_y, int color_r, int color_g, int color_b);
	int get_distance (int start_x, int start_y, int end_x, int end_y);
	graph_tga();
	virtual ~graph_tga();
private:
	error* err;
	unsigned char* coord_array;
	int size_x;
	int size_y;
};

#endif // !defined(AFX_graph_tga_H__3A88D5E6_D046_11D2_BDFF_AB9A94C6D301__INCLUDED_)
